#property copyright "*"
#property link      "*"

#property indicator_separate_window
#property indicator_buffers 5
#property indicator_color1 DodgerBlue
#property indicator_color2 Orange
#property indicator_color3 White
#property indicator_color4 Yellow
#property indicator_color5 Lime

#property indicator_maximum 1
#property indicator_minimum -1

#property indicator_level1 0.7
#property indicator_level2 -0.7

extern bool      ShowComment=false;  
extern int       Per=14;
extern bool      GBPUSD_v_EURUSD=true;
extern bool      AUDUSD_v_EURUSD=true;
extern bool      USDCHF_v_EURUSD=true;
extern bool      USDJPY_v_EURUSD=true;
extern bool      USDCAD_v_EURUSD=true;

 
 
double CloseEURUSD,CloseGBPUSD,CloseAUDUSD;
double CloseUSDCHF,CloseUSDJPY,CloseUSDCAD;
double summaEURUSD=0,summaGBPUSD=0,summaAUDUSD=0;
double summaUSDCHF=0,summaUSDJPY=0,summaUSDCAD=0;
double summaPow_EURUSD=0,summaPow_GBPUSD=0,summaPow_AUDUSD=0;
double summaPow_USDCHF=0,summaPow_USDJPY=0,summaPow_USDCAD=0;
double summa_eur_gbp=0,summa_eur_aud=0,summa_eur_chf=0,summa_eur_jpy=0,summa_eur_cad=0;
double sredneeEURUSD=0,sredneeGBPUSD=0,sredneeAUDUSD=0;
double sredneeUSDCHF=0,sredneeUSDJPY=0,sredneeUSDCAD=0;
double Q_eur_usd=0,Q_gbp_usd=0,Q_aud_usd=0,Q_usd_chf=0,Q_usd_jpy=0,Q_usd_cad=0;
double Correl_eur_gbp=0,Correl_eur_aud=0,Correl_eur_chf=0,Correl_eur_jpy=0,Correl_eur_cad=0;


double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];

//+------------------------------------------------------------------+
//| expert initialization function                                   |
//+------------------------------------------------------------------+
int init()
  {
//----
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);   
   
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);    
   
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,ExtMapBuffer3);    
   
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,ExtMapBuffer4);    
   
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,ExtMapBuffer5);    
   
   SetIndexLabel(0,"GBPUSD v EURUSD");
   SetIndexLabel(1,"AUDUSD v EURUSD");
   SetIndexLabel(2,"USDCHF v EURUSD");
   SetIndexLabel(3,"USDJPY v EURUSD");
   SetIndexLabel(4,"USDCAD v EURUSD");
   
   IndicatorDigits(2);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert deinitialization function                                 |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   if(ShowComment)Comment("");
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
int start(){

   int limit=Bars-IndicatorCounted()-1;
   
      for(int j=limit;j>=0;j--){
         sredneeEURUSD=0;
         sredneeGBPUSD=0;
         sredneeAUDUSD=0;
         sredneeUSDCHF=0;
         sredneeUSDJPY=0;
         sredneeUSDCAD=0;
         summaEURUSD=0;
         summaGBPUSD=0;
         summaAUDUSD=0;
         summaUSDCHF=0;
         summaUSDJPY=0;
         summaUSDCAD=0;
         summaPow_EURUSD=0;
         summaPow_GBPUSD=0;
         summaPow_AUDUSD=0;
         summaPow_USDCHF=0;
         summaPow_USDJPY=0;
         summaPow_USDCAD=0;
         summa_eur_gbp=0;
         summa_eur_aud=0;
         summa_eur_chf=0;
         summa_eur_jpy=0;
         summa_eur_cad=0;
         Q_eur_usd=0;
         Q_gbp_usd=0;
         Q_aud_usd=0;
         Q_usd_chf=0;
         Q_usd_jpy=0;
         Q_usd_cad=0;
         Correl_eur_gbp=0;
         Correl_eur_aud=0;
         Correl_eur_chf=0;
         Correl_eur_jpy=0;
         Correl_eur_cad=0;
            for (int i=0; i<Per; i++){
               CloseEURUSD=iClose("EURUSD",0,iBarShift("EURUSD",0,Time[i+j],false));//X
               if(GBPUSD_v_EURUSD)CloseGBPUSD=iClose("GBPUSD",0,iBarShift("GBPUSD",0,Time[i+j],false));//Y
               if(AUDUSD_v_EURUSD)CloseAUDUSD=iClose("AUDUSD",0,iBarShift("AUDUSD",0,Time[i+j],false));//Y
               if(USDCHF_v_EURUSD)CloseUSDCHF=iClose("USDCHF",0,iBarShift("USDCHF",0,Time[i+j],false));//Y
               if(USDJPY_v_EURUSD)CloseUSDJPY=iClose("USDJPY",0,iBarShift("USDJPY",0,Time[i+j],false));//Y
               if(USDCAD_v_EURUSD)CloseUSDCAD=iClose("USDCAD",0,iBarShift("USDCAD",0,Time[i+j],false));//Y
     
               summaEURUSD=summaEURUSD+CloseEURUSD;//Xi
               if(GBPUSD_v_EURUSD)summaGBPUSD=summaGBPUSD+CloseGBPUSD;//Yi
               if(AUDUSD_v_EURUSD)summaAUDUSD=summaAUDUSD+CloseAUDUSD;//Yi
               if(USDCHF_v_EURUSD)summaUSDCHF=summaUSDCHF+CloseUSDCHF;//Yi
               if(USDJPY_v_EURUSD)summaUSDJPY=summaUSDJPY+CloseUSDJPY;//Yi
               if(USDCAD_v_EURUSD)summaUSDCAD=summaUSDCAD+CloseUSDCAD;//Yi
     
               summaPow_EURUSD=summaPow_EURUSD+MathPow(CloseEURUSD,2);//Xi2
               if(GBPUSD_v_EURUSD)summaPow_GBPUSD=summaPow_GBPUSD+MathPow(CloseGBPUSD,2);//Yi2
               if(AUDUSD_v_EURUSD)summaPow_AUDUSD=summaPow_AUDUSD+MathPow(CloseAUDUSD,2);//Yi2
               if(USDCHF_v_EURUSD)summaPow_USDCHF=summaPow_USDCHF+MathPow(CloseUSDCHF,2);//Yi2
               if(USDJPY_v_EURUSD)summaPow_USDJPY=summaPow_USDJPY+MathPow(CloseUSDJPY,2);//Yi2
               if(USDCAD_v_EURUSD)summaPow_USDCAD=summaPow_USDCAD+MathPow(CloseUSDCAD,2);//Yi2
     
               if(GBPUSD_v_EURUSD)summa_eur_gbp=summa_eur_gbp+(CloseEURUSD*CloseGBPUSD);//XiYi
               if(AUDUSD_v_EURUSD)summa_eur_aud=summa_eur_aud+(CloseEURUSD*CloseAUDUSD);//XiYi
               if(USDCHF_v_EURUSD)summa_eur_chf=summa_eur_chf+(CloseEURUSD*CloseUSDCHF);//XiYi
               if(USDJPY_v_EURUSD)summa_eur_jpy=summa_eur_jpy+(CloseEURUSD*CloseUSDJPY);//XiYi
               if(USDCAD_v_EURUSD)summa_eur_cad=summa_eur_cad+(CloseEURUSD*CloseUSDCAD);//XiYi
            }
         sredneeEURUSD=summaEURUSD/Per;//X
         if(GBPUSD_v_EURUSD)sredneeGBPUSD=summaGBPUSD/Per;//Y
         if(AUDUSD_v_EURUSD)sredneeAUDUSD=summaAUDUSD/Per;//Y
         if(USDCHF_v_EURUSD)sredneeUSDCHF=summaUSDCHF/Per;//Y
         if(USDJPY_v_EURUSD)sredneeUSDJPY=summaUSDJPY/Per;//Y 
         if(USDCAD_v_EURUSD)sredneeUSDCAD=summaUSDCAD/Per;//Y

         Q_eur_usd=MathSqrt(summaPow_EURUSD/Per-MathPow(sredneeEURUSD,2));//Qx
         if(GBPUSD_v_EURUSD)Q_gbp_usd=MathSqrt(summaPow_GBPUSD/Per-MathPow(sredneeGBPUSD,2));//Qy
         if(AUDUSD_v_EURUSD)Q_aud_usd=MathSqrt(summaPow_AUDUSD/Per-MathPow(sredneeAUDUSD,2));//Qy
         if(USDCHF_v_EURUSD)Q_usd_chf=MathSqrt(summaPow_USDCHF/Per-MathPow(sredneeUSDCHF,2));//Qy
         if(USDJPY_v_EURUSD)Q_usd_jpy=MathSqrt(summaPow_USDJPY/Per-MathPow(sredneeUSDJPY,2));//Qy
         if(USDCAD_v_EURUSD)Q_usd_cad=MathSqrt(summaPow_USDCAD/Per-MathPow(sredneeUSDCAD,2));//Qy

         if(GBPUSD_v_EURUSD)if(Q_eur_usd*Q_gbp_usd!=0)Correl_eur_gbp=NormalizeDouble((summa_eur_gbp/Per-sredneeEURUSD*sredneeGBPUSD)/(Q_eur_usd*Q_gbp_usd),2);
         if(AUDUSD_v_EURUSD)if(Q_eur_usd*Q_aud_usd!=0)Correl_eur_aud=NormalizeDouble((summa_eur_aud/Per-sredneeEURUSD*sredneeAUDUSD)/(Q_eur_usd*Q_aud_usd),2);
         if(USDCHF_v_EURUSD)if(Q_eur_usd*Q_usd_chf!=0)Correl_eur_chf=NormalizeDouble((summa_eur_chf/Per-sredneeEURUSD*sredneeUSDCHF)/(Q_eur_usd*Q_usd_chf),2);
         if(USDJPY_v_EURUSD)if(Q_eur_usd*Q_usd_jpy!=0)Correl_eur_jpy=NormalizeDouble((summa_eur_jpy/Per-sredneeEURUSD*sredneeUSDJPY)/(Q_eur_usd*Q_usd_jpy),2);
         if(USDCAD_v_EURUSD)if(Q_eur_usd*Q_usd_cad!=0)Correl_eur_cad=NormalizeDouble((summa_eur_cad/Per-sredneeEURUSD*sredneeUSDCAD)/(Q_eur_usd*Q_usd_cad),2);

         if(GBPUSD_v_EURUSD)ExtMapBuffer1[j]=Correl_eur_gbp;
         if(AUDUSD_v_EURUSD)ExtMapBuffer2[j]=Correl_eur_aud;         
         if(USDCHF_v_EURUSD)ExtMapBuffer3[j]=Correl_eur_chf;         
         if(USDJPY_v_EURUSD)ExtMapBuffer4[j]=Correl_eur_jpy;         
         if(USDCAD_v_EURUSD)ExtMapBuffer5[j]=Correl_eur_cad;      
         
      } 
      if(ShowComment){ 
        string cs="\nEURUSD = 1";
        cs=cs+"\n----------------------------------------------------------------------------------";
        if(GBPUSD_v_EURUSD)cs=cs+"\n GBPUSD  EURUSD = "+DoubleToStr(Correl_eur_gbp,2);
        if(AUDUSD_v_EURUSD)cs=cs+"\n AUDUSD  EURUSD = "+DoubleToStr(Correl_eur_aud,2);
        if(USDCHF_v_EURUSD)cs=cs+"\n USDCHF  EURUSD = "+DoubleToStr(Correl_eur_chf,2);
        if(USDJPY_v_EURUSD)cs=cs+"\n USDJPY  EURUSD = "+DoubleToStr(Correl_eur_jpy,2);
        if(USDCAD_v_EURUSD)cs=cs+"\n USDCAD  EURUSD = "+DoubleToStr(Correl_eur_cad,2);
        Comment(cs);
     }
}